import java.util.concurrent.Flow;

public class DemoSubscriber implements Flow.Subscriber<Integer> {
    private static int subCum;
    private final int subNo;
    private Flow.Subscription subscription;

    DemoSubscriber() {
        subNo = ++subCum;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscr) {
        System.out.println("Subscriber " + subNo + " hat ein Subscription-Objekt erhalten (Thread: " + Thread.currentThread().getName() + ")");
        subscription = subscr;
        subscription.request(1);
    }

    @Override
    public void onNext(Integer ipar) {
        try {
            Thread.sleep(subNo*1000); // Kurzzeitiges Rumoren von individueller Dauer
        } catch (InterruptedException ie) {return;}
		System.out.println("Subscriber " + subNo + " hat Produkt " + ipar + " verarbeitet (Thread: " + Thread.currentThread().getName() + ")");
        subscription.request(1);
    }

    @Override
    public void onError(Throwable ex) {
        System.out.println("Der Subscriber " + subNo + " hat einen onError() - Aufruf erhalten: " + ex.getMessage());
    }

    @Override
    public void onComplete() {
        System.out.println("Der Subscriber " + subNo + " hat einen onComplete() - Aufruf erhalten.");
    }
}
